/*
 * Examples  : Arduino Examples By....ETT CO.,LTD
 * Program   : PCA9698_OUT
 * Software  : Arduino 1.8.4
 * Hardware  : ET-BASE AVR EASY328 + ET-I2C TO 40 IO-DIN
 * Function  : Test output PCA9698
 */
 
#include "Wire.h"
#define ADDR  0x40 >> 1     // Address for PCA9698 (AD2=VSS,AD1=VSS,AD0=VSS)

int out[8]={0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};

void setup() 
{
  Wire.begin();            // Initial I2C Bus

// Set up ports 0-4 
  Wire.beginTransmission(ADDR);
  Wire.write(0x98);        // Auto-Increment flag is set (AI = 1)  and  I/0 Configuration register bank 0 (0x18),Command register=10011000(0x98)
  Wire.write(0x00);        // PORT 0 for output
  Wire.write(0x00);        // PORT 1 for output
  Wire.write(0x00);        // PORT 2 for output
  Wire.write(0x00);        // PORT 3 for output
  Wire.write(0x00);        // PORT 4 for output
  Wire.endTransmission();
}

void loop() 
{
  for(int i=0;i<(sizeof(out)/sizeof(int));i++)    // Bit Counter Array Data
    {
      WriteP0(~out[i]);
      WriteP1(~out[i]);
      WriteP2(~out[i]);
      WriteP3(~out[i]);
      WriteP4(~out[i]);
      /*WriteP0(out[i]);
      WriteP1(out[i]);
      WriteP2(out[i]);
      WriteP3(out[i]);
      WriteP4(out[i]);*/
      delay(500);
    }
}

// Write data to PORT 0
void WriteP0(byte Output)
{
  Wire.beginTransmission(ADDR);
  Wire.write(0x08);   // Output Port register bank 0
  Wire.write(Output);
  Wire.endTransmission();
}

// Write data to PORT 1
void WriteP1(byte Output)
{
  Wire.beginTransmission(ADDR);
  Wire.write(0x09);   // Output Port register bank 1
  Wire.write(Output);
  Wire.endTransmission();
}

// Write data to PORT 2
void WriteP2(byte Output)
{
  Wire.beginTransmission(ADDR);
  Wire.write(0x0A);   // Output Port register bank 2
  Wire.write(Output);
  Wire.endTransmission();
}

// Write data to PORT 3
void WriteP3(byte Output)
{
  Wire.beginTransmission(ADDR);
  Wire.write(0x0B);   // Output Port register bank 3
  Wire.write(Output);
  Wire.endTransmission();
}

// Write data to PORT 1
void WriteP4(byte Output)
{
  Wire.beginTransmission(ADDR);
  Wire.write(0x0C);   // Output Port register bank 4
  Wire.write(Output);
  Wire.endTransmission();
}





